/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.init;

import cofh.core.block.TileBlockActive;
import cofh.core.block.TileBlockActive4Way;
import cofh.core.block.TileBlockCoFH;
import cofh.core.item.BlockItemCoFH;
import cofh.lib.block.GunpowderBlock;
import cofh.lib.block.HardenedGlassBlock;
import cofh.lib.block.OreBlockCoFH;
import cofh.lib.block.RubberBlock;
import cofh.lib.block.TntBlockCoFH;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.block.EnderiumBlock;
import cofh.thermal.core.block.EnderiumGlassBlock;
import cofh.thermal.core.block.LumiumBlock;
import cofh.thermal.core.block.LumiumGlassBlock;
import cofh.thermal.core.block.SignalumBlock;
import cofh.thermal.core.block.SignalumGlassBlock;
import cofh.thermal.core.block.device.TileBlockComposter;
import cofh.thermal.core.block.entity.ChargeBenchBlockEntity;
import cofh.thermal.core.block.entity.TinkerBenchBlockEntity;
import cofh.thermal.core.block.entity.device.DeviceCollectorTile;
import cofh.thermal.core.block.entity.device.DeviceComposterTile;
import cofh.thermal.core.block.entity.device.DeviceFisherTile;
import cofh.thermal.core.block.entity.device.DeviceHiveExtractorTile;
import cofh.thermal.core.block.entity.device.DeviceNullifierTile;
import cofh.thermal.core.block.entity.device.DevicePotionDiffuserTile;
import cofh.thermal.core.block.entity.device.DeviceRockGenTile;
import cofh.thermal.core.block.entity.device.DeviceSoilInfuserTile;
import cofh.thermal.core.block.entity.device.DeviceTreeExtractorTile;
import cofh.thermal.core.block.entity.device.DeviceWaterGenTile;
import cofh.thermal.core.block.entity.storage.EnergyCellBlockEntity;
import cofh.thermal.core.block.entity.storage.FluidCellBlockEntity;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.item.EnergyCellBlockItem;
import cofh.thermal.core.item.FluidCellBlockItem;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.lib.block.StorageCellBlock;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalItemGroups;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TCoreBlocks {
    private TCoreBlocks() {
    }

    public static void register() {
        TCoreBlocks.registerVanilla();
        TCoreBlocks.registerResources();
        TCoreBlocks.registerStorage();
        TCoreBlocks.registerBuildingBlocks();
        TCoreBlocks.registerMisc();
        TCoreBlocks.registerTileBlocks();
    }

    public static void setup() {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("charcoal_block"), 5, 5);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("gunpowder_block"), 15, 100);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("sugar_cane_block"), 60, 20);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("bamboo_block"), 60, 20);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("sawdust_block"), 10, 10);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("coal_coke_block"), 5, 5);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("bitumen_block"), 5, 5);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("tar_block"), 5, 5);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("rosin_block"), 5, 5);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("slime_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("redstone_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("glowstone_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("ender_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("phyto_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("earth_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("fire_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("ice_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("lightning_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("nuke_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ThermalCore.BLOCKS.get("gravity_tnt")), (DispenseItemBehavior)TntBlockCoFH.DISPENSER_BEHAVIOR);
    }

    private static void registerVanilla() {
        RegistrationHelper.registerBlockAndItem("charcoal_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76365_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56742_).m_60999_()), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("charcoal_block"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(16000));
        RegistrationHelper.registerBlock("gunpowder_block", () -> new GunpowderBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76273_, (MaterialColor)MaterialColor.f_76419_).m_60978_(0.5f).m_60918_(SoundType.f_56746_)));
        RegistrationHelper.registerBlock("sugar_cane_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76315_, (MaterialColor)MaterialColor.f_76405_).m_60978_(1.0f).m_60918_(SoundType.f_56758_)){

            public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.m_142535_(fallDistance, 0.6f, DamageSource.f_19315_);
            }
        });
        RegistrationHelper.registerBlock("bamboo_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76315_, (MaterialColor)MaterialColor.f_76405_).m_60978_(1.0f).m_60918_(SoundType.f_56754_)){

            public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.m_142535_(fallDistance, 0.8f, DamageSource.f_19315_);
            }
        });
        RegistrationHelper.registerBlock("apple_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76364_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), ThermalItemGroups.THERMAL_FOODS);
        RegistrationHelper.registerBlock("carrot_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76373_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), ThermalItemGroups.THERMAL_FOODS);
        RegistrationHelper.registerBlock("potato_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76384_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), ThermalItemGroups.THERMAL_FOODS);
        RegistrationHelper.registerBlock("beetroot_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76386_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), ThermalItemGroups.THERMAL_FOODS);
    }

    private static void registerResources() {
        RegistrationHelper.registerBlock("apatite_ore", () -> OreBlockCoFH.createStoneOre().xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_APATITE));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("apatite_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_APATITE));
        RegistrationHelper.registerBlock("cinnabar_ore", () -> OreBlockCoFH.createStoneOre().xp(1, 3), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CINNABAR));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("cinnabar_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(1, 3), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CINNABAR));
        RegistrationHelper.registerBlock("niter_ore", () -> OreBlockCoFH.createStoneOre().xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NITER));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("niter_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NITER));
        RegistrationHelper.registerBlock("sulfur_ore", () -> OreBlockCoFH.createStoneOre().xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SULFUR));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("sulfur_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SULFUR));
        RegistrationHelper.registerBlock("tin_ore", OreBlockCoFH::createStoneOre, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("tin_ore"), OreBlockCoFH::createDeepslateOre, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerBlock("lead_ore", OreBlockCoFH::createStoneOre, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("lead_ore"), OreBlockCoFH::createDeepslateOre, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerBlock("silver_ore", OreBlockCoFH::createStoneOre, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("silver_ore"), OreBlockCoFH::createDeepslateOre, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerBlock("nickel_ore", OreBlockCoFH::createStoneOre, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("nickel_ore"), OreBlockCoFH::createDeepslateOre, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerBlock("ruby_ore", () -> OreBlockCoFH.createStoneOre().xp(3, 7), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("ruby_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(3, 7), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerBlock("sapphire_ore", () -> OreBlockCoFH.createStoneOre().xp(3, 7), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
        RegistrationHelper.registerBlock(RegistrationHelper.deepslate("sapphire_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(3, 7), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
        RegistrationHelper.registerBlockAndItem("oil_sand", () -> new SandBlock(14406560, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("oil_sand"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_OIL)));
        RegistrationHelper.registerBlockAndItem("oil_red_sand", () -> new SandBlock(11098145, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49993_)), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("oil_red_sand"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_OIL)));
    }

    private static void registerStorage() {
        RegistrationHelper.registerBlock("apatite_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76375_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56742_).m_60999_()));
        RegistrationHelper.registerBlock("cinnabar_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76386_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56742_).m_60999_()));
        RegistrationHelper.registerBlock("niter_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76372_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56742_).m_60999_()));
        RegistrationHelper.registerBlockAndItem("sulfur_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76376_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56742_).m_60999_()){

            public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
                return side == Direction.UP;
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("sulfur_block"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(12000));
        RegistrationHelper.registerBlock(RegistrationHelper.raw("tin_block"), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76375_).m_60913_(5.0f, 6.0f).m_60999_()));
        RegistrationHelper.registerBlock(RegistrationHelper.raw("lead_block"), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(5.0f, 6.0f).m_60999_()));
        RegistrationHelper.registerBlock(RegistrationHelper.raw("silver_block"), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76380_).m_60913_(5.0f, 6.0f).m_60999_()));
        RegistrationHelper.registerBlock(RegistrationHelper.raw("nickel_block"), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76376_).m_60913_(5.0f, 6.0f).m_60999_()));
        RegistrationHelper.registerBlock("tin_block", TCoreBlocks::storageBlock, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerBlock("lead_block", TCoreBlocks::storageBlock, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerBlock("silver_block", TCoreBlocks::storageBlock, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerBlock("nickel_block", TCoreBlocks::storageBlock, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerBlock("bronze_block", TCoreBlocks::storageBlock, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_BRONZE));
        RegistrationHelper.registerBlock("electrum_block", TCoreBlocks::storageBlock, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_ELECTRUM));
        RegistrationHelper.registerBlock("invar_block", TCoreBlocks::storageBlock, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_INVAR));
        RegistrationHelper.registerBlock("constantan_block", TCoreBlocks::storageBlock, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CONSTANTAN));
        RegistrationHelper.registerBlock("signalum_block", () -> new SignalumBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76364_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60953_(BlockHelper.lightValue((int)7)).m_60955_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("lumium_block", () -> new LumiumBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76416_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60953_(BlockHelper.lightValue((int)15)).m_60955_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("enderium_block", () -> new EnderiumBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76421_).m_60913_(25.0f, 30.0f).m_60918_(SoundType.f_56727_).m_60999_().m_60953_(BlockHelper.lightValue((int)3)).m_60955_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("ruby_block", () -> TCoreBlocks.storageBlock(MaterialColor.f_76364_), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerBlock("sapphire_block", () -> TCoreBlocks.storageBlock(MaterialColor.f_76361_), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
        RegistrationHelper.registerBlockAndItem("sawdust_block", () -> new FallingBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(1.0f, 1.0f).m_60918_(SoundType.f_56746_)){

            @OnlyIn(value=Dist.CLIENT)
            public int m_6248_(BlockState state, BlockGetter reader, BlockPos pos) {
                return 11507581;
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("sawdust_block"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400));
        RegistrationHelper.registerBlockAndItem("coal_coke_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(5.0f, 6.0f).m_60999_()), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("coal_coke_block"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(32000));
        RegistrationHelper.registerBlockAndItem("bitumen_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56720_).m_60999_()), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("bitumen_block"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(16000));
        RegistrationHelper.registerBlockAndItem("tar_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76365_).m_60913_(2.0f, 4.0f).m_60956_(0.8f).m_60967_(0.8f).m_60918_(SoundType.f_56720_)){

            public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.m_142535_(fallDistance, 0.8f, DamageSource.f_19315_);
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("tar_block"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(8000));
        RegistrationHelper.registerBlockAndItem("rosin_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76413_).m_60913_(2.0f, 4.0f).m_60956_(0.8f).m_60967_(0.8f).m_60918_(SoundType.f_56751_)){

            public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.m_142535_(fallDistance, 0.8f, DamageSource.f_19315_);
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("rosin_block"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(8000));
        RegistrationHelper.registerBlock("rubber_block", () -> new RubberBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76372_).m_60913_(3.0f, 3.0f).m_60967_(1.25f).m_60918_(SoundType.f_56711_)));
        RegistrationHelper.registerBlock("cured_rubber_block", () -> new RubberBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76388_).m_60913_(3.0f, 3.0f).m_60967_(1.25f).m_60918_(SoundType.f_56711_)));
        RegistrationHelper.registerBlock("slag_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
        RegistrationHelper.registerBlock("rich_slag_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
    }

    private static void registerBuildingBlocks() {
        RegistrationHelper.registerBlock("machine_frame", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f).m_60955_()), ThermalFlags.getFlag("machine_frame"));
        RegistrationHelper.registerBlock("energy_cell_frame", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f).m_60955_()), ThermalFlags.getFlag("energy_cell_frame"));
        RegistrationHelper.registerBlock("fluid_cell_frame", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f).m_60955_()), ThermalFlags.getFlag("fluid_cell_frame"));
        RegistrationHelper.registerBlock("obsidian_glass", () -> new HardenedGlassBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76370_).m_60913_(5.0f, 1000.0f).m_60918_(SoundType.f_56744_).m_60955_()));
        RegistrationHelper.registerBlock("signalum_glass", () -> new SignalumGlassBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76364_).m_60913_(5.0f, 1000.0f).m_60918_(SoundType.f_56744_).m_60953_(BlockHelper.lightValue((int)7)).m_60955_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("lumium_glass", () -> new LumiumGlassBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76416_).m_60913_(5.0f, 1000.0f).m_60918_(SoundType.f_56744_).m_60953_(BlockHelper.lightValue((int)15)).m_60955_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("enderium_glass", () -> new EnderiumGlassBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76421_).m_60913_(5.0f, 1000.0f).m_60918_(SoundType.f_56744_).m_60953_(BlockHelper.lightValue((int)3)).m_60955_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("white_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("orange_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76413_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("magenta_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76414_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("light_blue_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76415_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("yellow_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76416_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("lime_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76417_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("pink_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76418_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("gray_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76419_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("light_gray_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76420_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("cyan_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76421_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("purple_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76422_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("blue_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76361_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("brown_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76362_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("green_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76363_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("red_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("black_rockwool", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56745_)));
        RegistrationHelper.registerBlock("polished_slag", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
        RegistrationHelper.registerBlock("chiseled_slag", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
        RegistrationHelper.registerBlock("slag_bricks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
        RegistrationHelper.registerBlock("cracked_slag_bricks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
        RegistrationHelper.registerBlock("polished_rich_slag", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
        RegistrationHelper.registerBlock("chiseled_rich_slag", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
        RegistrationHelper.registerBlock("rich_slag_bricks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
        RegistrationHelper.registerBlock("cracked_rich_slag_bricks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56718_).m_60999_()));
    }

    private static void registerMisc() {
    }

    private static void registerTileBlocks() {
        IntSupplier deviceAugs = () -> ThermalCoreConfig.deviceAugments;
        RegistrationHelper.registerAugmentableBlock("device_hive_extractor", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56756_).m_60978_(2.5f), DeviceHiveExtractorTile.class, TCoreTileEntities.DEVICE_HIVE_EXTRACTOR_TILE), deviceAugs, DeviceHiveExtractorTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_hive_extractor"));
        RegistrationHelper.registerAugmentableBlock("device_tree_extractor", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56756_).m_60978_(2.5f), DeviceTreeExtractorTile.class, TCoreTileEntities.DEVICE_TREE_EXTRACTOR_TILE), deviceAugs, DeviceTreeExtractorTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_tree_extractor"));
        RegistrationHelper.registerAugmentableBlock("device_fisher", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56756_).m_60978_(2.5f), DeviceFisherTile.class, TCoreTileEntities.DEVICE_FISHER_TILE), deviceAugs, DeviceFisherTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_fisher"));
        RegistrationHelper.registerAugmentableBlock("device_composter", () -> new TileBlockComposter(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56756_).m_60978_(2.5f), DeviceComposterTile.class, (Supplier<BlockEntityType<?>>)TCoreTileEntities.DEVICE_COMPOSTER_TILE), deviceAugs, DeviceComposterTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_composter"));
        RegistrationHelper.registerAugmentableBlock("device_soil_infuser", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56756_).m_60978_(2.5f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)10)), DeviceSoilInfuserTile.class, TCoreTileEntities.DEVICE_SOIL_INFUSER_TILE), deviceAugs, DeviceSoilInfuserTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_soil_infuser"));
        RegistrationHelper.registerAugmentableBlock("device_water_gen", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f), DeviceWaterGenTile.class, TCoreTileEntities.DEVICE_WATER_GEN_TILE), deviceAugs, DeviceWaterGenTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_water_gen"));
        RegistrationHelper.registerAugmentableBlock("device_rock_gen", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)14)), DeviceRockGenTile.class, TCoreTileEntities.DEVICE_ROCK_GEN_TILE), deviceAugs, DeviceRockGenTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_rock_gen"));
        RegistrationHelper.registerAugmentableBlock("device_collector", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f), DeviceCollectorTile.class, TCoreTileEntities.DEVICE_COLLECTOR_TILE), deviceAugs, DeviceCollectorTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_collector"));
        RegistrationHelper.registerAugmentableBlock("device_nullifier", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)7)), DeviceNullifierTile.class, TCoreTileEntities.DEVICE_NULLIFIER_TILE), deviceAugs, DeviceNullifierTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_nullifier"));
        RegistrationHelper.registerAugmentableBlock("device_potion_diffuser", () -> new TileBlockActive4Way(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f), DevicePotionDiffuserTile.class, TCoreTileEntities.DEVICE_POTION_DIFFUSER_TILE), deviceAugs, DevicePotionDiffuserTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_potion_diffuser"));
        IntSupplier storageAugs = () -> ThermalCoreConfig.storageAugments;
        RegistrationHelper.registerAugmentableBlock("tinker_bench", () -> new TileBlockCoFH(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56756_).m_60978_(2.5f), TinkerBenchBlockEntity.class, TCoreTileEntities.TINKER_BENCH_TILE), storageAugs, TinkerBenchBlockEntity.AUG_VALIDATOR, ThermalFlags.getFlag("tinker_bench"));
        RegistrationHelper.registerAugmentableBlock("charge_bench", () -> new TileBlockActive(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)7)), ChargeBenchBlockEntity.class, TCoreTileEntities.CHARGE_BENCH_TILE), storageAugs, ChargeBenchBlockEntity.AUG_VALIDATOR, ThermalFlags.getFlag("charge_bench"));
        ThermalCore.BLOCKS.register("energy_cell", () -> new StorageCellBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f).m_60955_(), EnergyCellBlockEntity.class, (Supplier<BlockEntityType<?>>)TCoreTileEntities.ENERGY_CELL_TILE));
        ThermalCore.ITEMS.register("energy_cell", () -> new EnergyCellBlockItem((Block)ThermalCore.BLOCKS.get("energy_cell"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_DEVICES)).setNumSlots(storageAugs).setAugValidator(ThermalAugmentRules.ENERGY_STORAGE_VALIDATOR).setShowInGroups(ThermalFlags.getFlag("energy_cell")));
        ThermalCore.BLOCKS.register("fluid_cell", () -> new StorageCellBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f).m_60955_(), FluidCellBlockEntity.class, (Supplier<BlockEntityType<?>>)TCoreTileEntities.FLUID_CELL_TILE));
        ThermalCore.ITEMS.register("fluid_cell", () -> new FluidCellBlockItem((Block)ThermalCore.BLOCKS.get("fluid_cell"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_DEVICES)).setNumSlots(storageAugs).setAugValidator(FluidCellBlockEntity.AUG_VALIDATOR).setShowInGroups(ThermalFlags.getFlag("fluid_cell")));
    }

    public static Block storageBlock() {
        return new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60999_());
    }

    public static Block storageBlock(MaterialColor color) {
        return new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)color).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60999_());
    }
}

